% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testKron_auto.R
\name{testKron_auto}
\alias{testKron_auto}
\title{Testing Kronecker product structure without specified modes}
\usage{
testKron_auto(
  ten,
  r = 0,
  alpha = c(0.01, 0.05),
  q = 0.05,
  r.exact = FALSE,
  all = FALSE
)
}
\arguments{
\item{ten}{An array representing an order-(K+1) tensor which is an order-K tensor time series with mode-1 being the time mode.}

\item{r}{A vector representing the rank for 'ten'.}

\item{alpha}{A vector representing the desired significance levels. Default is c(0.01, 0.05).}

\item{q}{A number between 0 and 1, representing the quantile for the decision statistic. Default is 0.05.}

\item{r.exact}{Logical. Perform the test only using 'r' if TRUE, otherwise using all divisor combinations of the last mode rank of the reshaped data. Default is FALSE.}

\item{all}{Logical. when TRUE, all sets of mode indices are tested; otherwise each reshaped data using leave-one-out sets is sequentially tested. Default is FALSE.}
}
\value{
A list containing the following:
decision: a data frame with each row reporting the decision rule aggregated by quantile of parameter 'q' for different levels of alpha; the first column represents all non-trivial sets of mode indices to test if 'all' is TRUE, otherwise represents each mode to identify.
level: a data frame with each row reporting an example test size aggregated by quantile of parameter 'q' for different levels of alpha; the first column represents all non-trivial sets of mode indices to test if 'all' is TRUE, otherwise represents each mode to identify.
rank: a vector of integers representing either the input rank or the estimated rank used in testing.
}
\description{
Testing the Kronecker product structure of a tensor time series without a specified set of mode indices.
}
