% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{seishu_wine_df}
\alias{seishu_wine_df}
\title{The Seishu Wine Study}
\format{
A data frame with 30 observations and 10 variables:
\describe{
  \item{Taste}{Taste rating of the wine (numeric)}
  \item{Odor}{Odor rating of the wine (numeric)}
  \item{pH}{pH concentration (numeric)}
  \item{Acidity_1}{First acidity measurement (numeric)}
  \item{Acidity_2}{Second acidity measurement (numeric)}
  \item{Sake_meter}{Sake meter value (numeric)}
  \item{Direct_reducing_sugar}{Direct reducing sugar content (numeric)}
  \item{Total_sugar}{Total sugar content (numeric)}
  \item{Alcohol}{Alcohol content (numeric)}
  \item{Formyl_nitrogen}{Formyl nitrogen content (numeric)}
}
}
\source{
Data taken from the ACSWR package version 1.0
}
\usage{
data(seishu_wine_df)
}
\description{
This dataset, seishu_wine_df, is a data frame containing data from a study on wine.
The study records the odor and taste of wines, with the aim of explaining these characteristics
through various chemical properties such as pH concentration, alcohol content, total sugar, and others.
}
\details{
The dataset name has been kept as 'seishu_wine_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
JapanAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
