% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{iscamboxplot}
\alias{iscamboxplot}
\title{A box plot}
\usage{
iscamboxplot(
  response,
  explanatory = NULL,
  main = "",
  xlab = "",
  ylab = substitute(explanatory)
)
}
\arguments{
\item{response}{Vector of numeric values to plot.}

\item{explanatory}{Optional second categorical variable to group by.}

\item{main}{Optional title for the plot}

\item{xlab}{Optional x-axis label for the plot}

\item{ylab}{Optional y-axis label for the plot. Only displayed when \code{explanatory} is provided.}
}
\value{
A box plot.
}
\description{
\code{boxplot} plots the given data in a box plot. If a second categorical variable
is given, the data is grouped by this variable.
}
\examples{
iscamboxplot(
  mtcars$mpg,
  main = "mtcars Cylinders Dotplot",
  xlab = "Number of Cylinders"
)
iscamboxplot(
  mtcars$mpg,
  mtcars$am,
  main = "Automatic Cars Have Better Mileage on Average",
  xlab = "Mileage (miles per gallon)",
  ylab = "Automatic (yes coded as 1)"
)
}
