% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stModel.define.R
\name{stModel.define}
\alias{stModel.define}
\title{Define a spacetime model object for the \code{f()} call.}
\usage{
stModel.define(
  smesh,
  tmesh,
  model,
  control.priors,
  constr = FALSE,
  debug = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{smesh}{a spatial mesh}

\item{tmesh}{a temporal mesh}

\item{model}{a three characters string to specify the
smoothness alpha (each one as integer) parameters.
Currently it considers the \code{102}, \code{121}, \code{202} and \code{220} models.}

\item{control.priors}{a named list with parameter priors,
named as \code{prs}, \code{prt} and \code{psigma}, each one as a vector
with length two containing (U, a) to define the
corresponding PC-prior such that, respectively,
P(range.spatial<U)=a, P(range.temporal<U)=a or P(sigma>U)=a.
If a=0 or a=NA, then U is taken to be the fixed
value of the parameter.}

\item{constr}{logical, default is FALSE, to indicate if the
integral of the field over the domain is to be constrained to zero.}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'libpath' is provided.}

\item{libpath}{string, default is NULL, with the path to the shared object.}
}
\value{
objects to be used in the f() formula term in INLA.
}
\description{
Define a spacetime model object for the \code{f()} call.
}
\details{
This function compute the matrices for computing the precision matrix.
These are each one of the Kronecker products in Theorem 4.1 of
Lindgren et. al. (2024) computed with the
\link{stModel.matrices} and the parameters are as in Eq (19-21).
We use the log of these parameters internally.
}
\references{
Finn Lindgren, Haakon Bakka, David Bolin, Elias Krainski and Håvard Rue (2024).
A diffusion-based spatio-temporal extension of Gaussian Matérn fields.
\href{https://raco.cat/index.php/SORT/article/view/428665}{SORT vol.  48, no. 1, pp. 3-66}
<doi: 10.57645/20.8080.02.13>
}
