% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVariancePartitioning.R
\name{plotVariancePartitioning}
\alias{plotVariancePartitioning}
\title{plotVariancePartitioning}
\usage{
plotVariancePartitioning(
  hM,
  VP,
  cols = NULL,
  main = "Variance Partitioning",
  ...
)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{VP}{a Hmsc variance partitioning object produced by \code{\link{computeVariancePartitioning}}}

\item{cols}{colors of the barplot}

\item{main}{main title for the plot}

\item{...}{additional parameters passed to the barplot function}
}
\description{
Plots the results of variance partitioning of a \code{Hmsc} model produced by
\code{\link{computeVariancePartitioning}} as a barplot
}
\examples{
# Plot how the explained variance of a previously fitted model is partitioned
VP = computeVariancePartitioning(TD$m)
plotVariancePartitioning(TD$m, VP)

}
