% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_sequence.R
\name{reconstruct_sequence}
\alias{reconstruct_sequence}
\title{Reconstruct protein sequence}
\usage{
reconstruct_sequence(
  dat,
  protein = dat[["Protein"]][1],
  states = unique(dat[["State"]]),
  end = NULL
)
}
\arguments{
\item{dat}{data read by \code{\link{read_hdx}}}

\item{protein}{selected protein}

\item{states}{selected biological states for given protein}

\item{end}{\code{\link{numeric}}, end position of the protein}
}
\value{
a \code{\link{character}} object.
}
\description{
Reconstruct protein sequence from
experimental data
}
\details{
The function \code{\link{reconstruct_sequence}} 
generates protein sequence from supplied experimental data. 
For a position not covered, letter x is shown.
If the C-terminus of protein is not covered, there is a
possibility to manually fix the protein length by passing
a value to the `end` parameter.
}
\examples{
reconstruct_sequence(alpha_dat)

}
\seealso{
\code{\link{read_hdx}}
}
