% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_replicate_mass_uptake.R
\name{plot_replicate_mass_uptake}
\alias{plot_replicate_mass_uptake}
\title{Replicate mass uptake curve}
\usage{
plot_replicate_mass_uptake(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  sequence = dat[["Sequence"]][1],
  aggregated = FALSE,
  log_x = TRUE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{protein}{selected protein}

\item{state}{selected biological state for given protein}

\item{sequence}{selected peptide sequence for given protein 
in given biological state}

\item{aggregated}{\code{logical}, indicator if presented
data is aggregated on replicate level}

\item{log_x}{\code{logical}, indicator if the X axis values 
are transformed to log10}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot the mass uptake curve for selected
peptide to see the difference between replicates.
}
\details{
The function \code{\link{plot_replicate_mass_uptake}}
generates a plot showing the mass uptake for selected protein 
in replicates of the experiments. The values can be presented 
in two ways: as aggregated values for each replicate, or before
aggregation - measured values for charge values within a replicate.
The mass uptake is generated by subtracting the MHP mass of a peptide
from measured mass and the mass uptake is presented in Daltons.
}
\examples{
plot_replicate_mass_uptake(alpha_dat)
plot_replicate_mass_uptake(alpha_dat, aggregated = TRUE)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_exp_masses_per_replicate}}
}
