% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_p_diff_uptake_dataset.R
\name{create_p_diff_uptake_dataset}
\alias{create_p_diff_uptake_dataset}
\title{Create differential uptake dataset with p-value}
\usage{
create_p_diff_uptake_dataset(
  dat,
  diff_uptake_dat = NULL,
  protein = unique(dat[["Protein"]])[1],
  state_1 = unique(dat[["State"]])[1],
  state_2 = unique(dat[["State"]])[2],
  p_adjustment_method = "none",
  confidence_level = 0.98,
  time_0 = min(dat[["Exposure"]]),
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{diff_uptake_dat}{differential uptake data}

\item{protein}{chosen protein.}

\item{state_1}{biological state for chosen protein. From this state values
the second state values are subtracted to get the deuterium uptake difference.}

\item{state_2}{biological state for chosen protein. This state values are 
subtracted from the first state values to get the deuterium uptake difference.}

\item{p_adjustment_method}{method of adjustment P-values for multiple 
comparisons. Possible methods: "BH" (Benjamini & Hochberg correction), 
"bonferroni" (Bonferroni correction) and "none" (default).}

\item{confidence_level}{confidence level for the t-test.}

\item{time_0}{minimal exchange control time point of measurement [min].}

\item{time_100}{maximal exchange control time point of measurement [min].}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object with calculated deuterium uptake difference
in different forms with their uncertainty, P-value and -log(P-value) for the peptides 
from the provided data.
}
\description{
Creates differential deuterium uptake dataset
with P-value from t-Student test for selected two biological 
states.
}
\details{
For peptides in all of the time points of measurement (except for minimal
and maximal exchange control) the deuterium uptake difference between state_1
and state_2 is calculated, with its uncertainty (combined and propagated as
described in `Data processing` article). For each peptide in time point the 
P-value is calculated using unpaired t-test. The deuterium uptake difference
is calculated as the difference of measured masses in a given time point for two 
states. The tested hypothesis is that the mean masses for states from the 
replicates of the experiment are similar. The P-values indicates if the null
hypothesis can be rejected - rejection of the hypothesis means that the 
difference between states is statistically significant at provided confidence
level. The P-values can be adjusted using the provided method.
}
\examples{
p_diff_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
head(p_diff_uptake_dat)

}
\references{
Hageman, T. S. & Weis, D. D. Reliable Identification of Significant 
Differences in Differential Hydrogen Exchange-Mass Spectrometry Measurements 
Using a Hybrid Significance Testing Approach. Anal Chem 91, 8008–8016 (2019).
}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_exp_masses_per_replicate}}
}
