% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_box_plot}
\alias{hnp_box_plot}
\title{HNP Box Plot Experiment}
\usage{
hnp_box_plot(
  data,
  class_col,
  method = "logistic",
  n_runs = 100,
  levels = c(0.05, 0.05),
  tolerances = c(0.05, 0.05),
  output_file = NULL,
  hnp_split = NULL,
  split_ratio = c(0.7, 0.3)
)
}
\arguments{
\item{data}{A data.frame containing features and class label.}

\item{class_col}{Character. Name of the class column (must be mapped to "1","2","3").}

\item{method}{Character. Base classifier method ('randomforest', 'svm', 'logistic').}

\item{n_runs}{Integer. Number of iterations to run.}

\item{levels}{Numeric vector. Alpha levels (constraints) for classes (e.g., c(0.05, 0.1)).}

\item{tolerances}{Numeric vector. Delta tolerances for classes (e.g., c(0.01, 0.02)).}

\item{output_file}{Character. Path to save the PDF output.}

\item{hnp_split}{List. Split configuration for HNP internal validation.}

\item{split_ratio}{Numeric vector. Ratio of data used for training and testing (e.g., c(0.7, 0.3)).}
}
\value{
No return value, called for side effects.
}
\description{
Runs multiple iterations of HNP experiment on a dataset (with random 7:3 splits)
and generates a PDF with 15 boxplots comparing Before vs After NP performance.
}
\examples{
set.seed(123)
n <- 2000
features <- data.frame(
  x1 = rnorm(n),
  x2 = rnorm(n)
)
y <- factor(sample(c("1", "2", "3"), n, replace = TRUE, prob = c(0.2, 0.3, 0.5)))
data <- cbind(features, y)
hnp_box_plot(
  data = data,
  class_col = "y",
  method = "logistic", 
  n_runs = 2,
  levels = c(0.05, 0.05),
  tolerances = c(0.05, 0.05),
  output_file = tempfile(fileext = ".pdf")
)
}
