% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_spread.R
\name{spread}
\alias{spread}
\alias{spreadVertical}
\alias{spreadHorizontal}
\title{Spread boxes}
\usage{
spreadVertical(
  ...,
  .from = NULL,
  .to = NULL,
  .margin = unit(0, "npc"),
  .type = c("between", "center"),
  .subelement = NULL
)

spreadHorizontal(
  ...,
  .from = NULL,
  .to = NULL,
  .margin = unit(0, "npc"),
  .type = c("between", "center"),
  .subelement = NULL
)
}
\arguments{
\item{...}{A set of boxes to spread. Can also be a \code{list} of boxes.}

\item{.from}{Starting point of the span. Can be a box, a coordinate/unit, or a
numeric value interpreted as \code{npc}. If only \code{.from} is provided, \code{.to} defaults
to \verb{1 npc}.}

\item{.to}{Ending point of the span. Can be a box, a coordinate/unit, or a
numeric value interpreted as \code{npc}. If only \code{.to} is provided, \code{.from} defaults
to \verb{0 npc}.}

\item{.margin}{Optional padding applied at both ends of the span. Can be a
\code{\link[grid:unit]{grid::unit}} or a numeric value interpreted as \code{npc}. Applied whether the
span comes from \code{.from} / \code{.to} or the viewport.}

\item{.type}{If \code{between}, the space \emph{between} boxes is identical. If \code{center},
the centers of the boxes are equally distributed across the span.}

\item{.subelement}{If a \code{list} of boxes is provided, this parameter can be used
to target a specific element (by name or index) for the spreading operation.
The function will then return the original list with the targeted element
replaced by its spread version.}
}
\value{
A \code{list} with the boxes that have been spread.
}
\description{
Spreads a set of \code{\link{boxGrob}}/\code{\link{boxPropGrob}} in either horizontal or vertical
direction within a given span.
}
\details{
The span can be defined explicitly using \code{.from} / \code{.to}, or implicitly by the
current viewport. Numeric values are interpreted as proportions of the viewport
(\code{npc} units).
}
\examples{
library(grid)
grid.newpage()

# Create a set of boxes
start <- boxGrob("Top", x = .5, y = .8)
end <- boxGrob("Bottom", x = .5, y = .2)
side <- boxPropGrob("Side", "Left", "Right", prop = .3, x = .2, y = .8)
exclude <- boxGrob("Exclude:\n - Too sick\n - Prev. surgery", x = .8, y = .5, just = "left")

# We can chain the spread operations
boxes <- spreadVertical(
  start = start,
  middle = list(side, exclude),
  end = end
) |>
  spreadHorizontal(.subelement = "middle", .from = 0.2, .to = 0.8)

# Now we can print them all at once
boxes
}
\seealso{
Other flowchart components: 
\code{\link{align}},
\code{\link{boxGrob}()},
\code{\link{boxPropGrob}()},
\code{\link{boxShapes}},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{distance}()},
\code{\link{moveBox}()}
}
\concept{flowchart components}
