% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_labelConnector.R
\name{setConnectorLabels}
\alias{setConnectorLabels}
\title{Attach labels to a connector object}
\usage{
setConnectorLabels(
  con,
  labels,
  gp = gpar(cex = 0.9),
  bg_gp = gpar(fill = "white", col = NA),
  x_offset = unit(0, "mm"),
  y_offset = unit(0, "mm")
)
}
\arguments{
\item{con}{A connector (a `connect_boxes` grob or `connect_boxes_list`).}

\item{labels}{Character vector of labels (recycled to match connector length).}

\item{gp}{A `gpar` for label text.}

\item{bg_gp}{A `gpar` for label background.}

\item{x_offset, y_offset}{Unit offsets for label placement.}
}
\value{
The connector object with attributes set (invisibly).
}
\description{
Store labels and presentation options on a connector object so labels are
automatically drawn when the connector is printed.
}
