% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_boxGrob.R, R/boxGrobs_S3_fns.R
\name{boxGrob}
\alias{boxGrob}
\alias{print.box}
\alias{plot.box}
\alias{widthDetails.box}
\alias{heightDetails.box}
\title{Create a box with text}
\usage{
boxGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black", cex = 1)),
  box_gp = getOption("boxGrob", default = gpar(fill = "white")),
  box_fn = roundrectGrob,
  name = NULL
)

\method{print}{box}(x, ...)

\method{plot}{box}(x, ...)

\method{widthDetails}{box}(x)

\method{heightDetails}{box}(x)
}
\arguments{
\item{label}{The label to print - should be a number, text or expression.}

\item{y}{The y position to put the box at. Can be either in \code{npc} (i.e. 0-1) or a \code{\link[grid]{unit}}.}

\item{x}{The x position to put the box at. Can be either in \code{npc} (i.e. 0-1) or a \code{\link[grid]{unit}}.}

\item{width}{The box automatically adapts the size but you can force by specifying the width}

\item{height}{The box automatically adapts the size but you can force by specifying the height}

\item{just}{The justification for the text: left, center or right.}

\item{bjust}{The justification for the box: left, center, right, top or bottom.
See the \code{just} option for the \code{\link[grid]{viewport}}}

\item{txt_gp}{The \code{\link[grid]{gpar}} style to apply to the text. Set \code{boxGrobTxt} option
if you want to customize all the boxes at once.}

\item{box_gp}{The \code{\link[grid]{gpar}} style to apply to the box function of `box_fn` below.}

\item{box_fn}{Function to create box for the text. Parameters of `x=0.5`, `y=0.5` and `box_gp` will
be passed to this function and return a \code{grob} object.}

\item{name}{a character identifier for the \code{grob}. Used to find the \code{grob} on the display
list and/or as a child of another grob.}

\item{...}{Passed to \code{\link[grid]{grid.draw}}}
}
\value{
A grob
}
\description{
Creates a \code{\link[grid:grid.grob]{grob}} box with text inside it.
}
\section{The \code{plot}/\code{print}}{


To output the \code{\link[grid:grid.grob]{grob}} objects to the plot either call \code{plot}
on the object or \code{print} it. Note that R automatically prints any object that is outputted
to the console. The function calls in turn the \code{\link[grid]{grid.draw}} function on the object.
}

\section{S3 from the \pkg{grid} package}{


Width and height functions address the \code{\link{coords}} attribute for the corresponding information.
The \code{\link[grid:widthDetails]{widthDetails}} and \code{\link[grid:widthDetails]{heightDetails}}
that provide information on an object.
}

\examples{
# Note: grid functions are explicitly namespaced in examples to avoid
# relying on attaching the grid package in R CMD check.
grid::grid.newpage()
boxGrob("My box")
}
\seealso{
The package provides several convenience shape helpers that can be
passed to `boxGrob(..., box_fn = ...)`: \code{boxDiamondGrob},
\code{boxEllipseGrob}, \code{boxRackGrob}, \code{boxServerGrob},
\code{boxDatabaseGrob}, \code{boxDocumentGrob}, \code{boxDocumentsGrob}, and
\code{boxTapeGrob}. For examples see the vignette: \code{vignette("Grid-based_flowcharts", package = "Gmisc")}.

Other flowchart components: 
\code{\link{align}},
\code{\link{boxPropGrob}()},
\code{\link{boxShapes}},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{distance}()},
\code{\link{moveBox}()},
\code{\link{spread}}
}
\concept{flowchart components}
