% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimGOUexact.R
\name{SimGOUexact}
\alias{SimGOUexact}
\title{Simulation of generalized Ornstein-Uhlenbeck (GOU) process}
\usage{
SimGOUexact(T1, N, t_star = 0, K, theta, theta_star, sigma)
}
\arguments{
\item{T1}{Last time of observation}

\item{N}{Number of observations on from on interval (0,T1]}

\item{t_star}{Time of change-point after T1}

\item{K}{Number of observation after change-point}

\item{theta}{list of parameters before change-point: cos coefficients (>=1), sine and sigma}

\item{theta_star}{list of parameters after  change-point: cos coefficients (>=1), sine and sigma}

\item{sigma}{volatility parameter of the GOU process}
}
\value{
\item{X}{Simulated path evaluated at points k x T1/N, 0 <= k <= N+K}
}
\description{
Function to simulate exact N+K+1 values with change point after N+K_star, with  K_star = floor(N*t_star), for a GOU process. Starting point is 0.
}
\examples{
set.seed(3253)
T1=20
N=500
K=2*N
t_star=0
theta=list(cos=c(1,2),alpha=1) # d=3 parameters for the drift
theta_star=list(cos=c(2,5),alpha=1)
sigma=3
X=SimGOUexact(T1,N,t_star,K,theta,theta_star,sigma)
}
