% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_qq.R
\name{flex_qqplot}
\alias{flex_qqplot}
\title{flex_qqplot function}
\usage{
flex_qqplot(
  gwas_data,
  interactive = TRUE,
  display_ks = FALSE,
  user_colors = c("dodgerblue", "darkorange"),
  user_title = "QQ Plot",
  user_x_title = "Theoretical Quantiles",
  user_y_title = "Observed Quantiles",
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(title = element_text(size = 15), axis.text =
    element_text(size = 10), axis.title = element_text(size = 10)),
  annotate_data = NULL,
  annotate_column = "SNP",
  annotate_labels = FALSE,
  zoom_on_annotations = FALSE,
  zoom_margin = 1,
  ...
)
}
\arguments{
\item{gwas_data}{A data frame containing columns for SNP ID ('SNP’), chromosome ('CHR'),
position ('POS'), and p-values ('P_VALUE').}

\item{interactive}{Logical, whether to return an interactive plot (TRUE) or static ggplot (FALSE).}

\item{display_ks}{Logical, whether to display the Kolmogorov-Smirnov (KS) test result.}

\item{user_colors}{Character vector of length 2 specifying the colors for points and reference line.}

\item{user_title}{The title of the plot.}

\item{user_x_title}{The title for the x-axis.}

\item{user_y_title}{The title for the y-axis.}

\item{user_plot_theme}{A ggplot2 theme object to style the plot.}

\item{user_plot_theme_specs}{Additional ggplot2 theme specifications to override in \code{user_plot_theme}.}

\item{annotate_data}{A vector of SNP identifiers to annotate in the plot.}

\item{annotate_column}{The name of the column in \code{gwas_data} to use for matching \code{annotate_data}.}

\item{annotate_labels}{Logical, whether to label the annotated points.}

\item{zoom_on_annotations}{Logical, whether to create a zoomed version of the plot focusing on annotated SNPs.}

\item{zoom_margin}{Numeric, the margin size around zoomed points.}

\item{...}{Additional arguments to be passed to ggplot2 plotting functions.}
}
\value{
An object of class 'ggplot' or 'plotly' depending on the 'interactive' parameter.
}
\description{
This function generates a customizable quantile-quantile (QQ) plot for GWAS data,
allowing for interactive exploration, zooming on specific SNPs, and inclusion
of a Kolmogorov-Smirnov test result annotation.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
flex_qqplot(example_data1, user_colors = c("black", "darkorange"))
flex_qqplot(example_data1, display_ks = TRUE, interactive = FALSE)
annotated_snps <- c("SNP_1", "SNP_2", "SNP_3")
flex_qqplot(example_data1, annotate_data = annotated_snps, annotate_labels = TRUE)
flex_qqplot(example_data1, annotate_data = annotated_snps, annotate_labels = TRUE, 
display_ks = TRUE)
flex_qqplot(example_data1, annotate_data = annotated_snps, annotate_labels = TRUE, 
zoom_on_annotations = TRUE, zoom_margin = 0.3, user_plot_theme = theme_bw())
}
