% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{gev.profxi.mdfy}
\alias{gev.profxi.mdfy}
\title{Modified profile likelihood for GEV shape parameter}
\usage{
gev.profxi.mdfy(
  data = NULL,
  mle = NULL,
  xlow,
  xup,
  pick.v = NULL,
  nint = 256,
  figure = FALSE
)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{mle}{MLE parameter estimates (mu, sigma, xi) in Coles parameterization.}

\item{xlow}{Lower bound for xi search.}

\item{xup}{Upper bound for xi search.}

\item{pick.v}{Numeric vector of confidence levels for CI computation.}

\item{nint}{Number of grid points. Default is 256.}

\item{figure}{Logical. Whether to plot the profile likelihood. Default is FALSE.}
}
\value{
A list containing:
\describe{
  \item{fail}{Logical. TRUE if profile likelihood is degenerate}
  \item{start}{Starting method recommendation}
  \item{w1}{Profile CI results from \code{comp.prof.ci()}}
  \item{ymin}{Minimum y value for plotting}
  \item{ymax}{Maximum y value for plotting}
}
}
\description{
Internal function that computes the profile log-likelihood
for the GEV shape parameter with linear extrapolation beyond the
observed range. Used for constructing confidence intervals on xi.
}
\keyword{internal}
