% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{comp.prof.ci}
\alias{comp.prof.ci}
\title{Compute profile likelihood confidence intervals}
\usage{
comp.prof.ci(d, v, conf = NULL)
}
\arguments{
\item{d}{Data frame with columns \code{x} (xi values) and \code{v} (log-likelihood).}

\item{v}{Numeric vector of log-likelihood values.}

\item{conf}{Numeric vector of confidence levels (e.g., 0.95).}
}
\value{
A list containing:
\describe{
  \item{vmax}{Maximum log-likelihood value}
  \item{nllh}{Same as vmax}
  \item{xmax}{xi value at maximum likelihood}
  \item{ci1}{Lower CI bounds for each confidence level}
  \item{ci2}{Upper CI bounds for each confidence level}
  \item{ci_length}{CI lengths for each confidence level}
}
}
\description{
Internal function that extracts confidence intervals from
a profile log-likelihood curve at specified confidence levels.
}
\keyword{internal}
