% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table_methods.R
\name{si_to_mai_max}
\alias{si_to_mai_max}
\title{Convert a Standard Site Index Into an maximum MAI Site Index}
\usage{
si_to_mai_max(si, mai_variable, ytable)
}
\arguments{
\item{si}{Standard site index to be converted, must correspond to the site
index nomenclature of the yield table to be used (param \code{ytable}, see
below).}

\item{mai_variable}{Character, name of the mai_variable to be used. Must be
one if the mai variables listed in the \code{fe_yield_table} object
provided with the parameter \code{ytable}.}

\item{ytable}{An object of class \code{fe_yield_table}}
}
\value{
The requested maximum mai value corresponding to the given standard
site index
}
\description{
A less common, but sometimes useful way of site indexing is to give the site
function converts a standard site index into such an maximum mai site index.
Typically, the stand age where the maximum mai is obtained increases from
better to lesser site index classes. See \code{\link{si_to_mai_age}} for an
alternative mai based site indexing method.
}
\examples{
 mai_var <- "mai_m3_ha_yr" # mai in volume over bark before harvest

 si_to_mai_max(2.3, mai_var, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_max(0.7, mai_var, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_max(2.3, mai_var, fe_ytable_beech_wiedemann_moderate_1931)
 si_to_mai_max(0.7, mai_var, fe_ytable_beech_wiedemann_moderate_1931)

 mai_var <- "red_mai_m3_ha_yr" # mai in vol. under bark minus harvest losses
 si_to_mai_max(2.3, mai_var, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_max(0.7, mai_var, fe_ytable_larch_schober_moderate_1946)
 si_to_mai_max(2.3, mai_var, fe_ytable_beech_wiedemann_moderate_1931)
 si_to_mai_max(0.7, mai_var, fe_ytable_beech_wiedemann_moderate_1931)

}
\seealso{
Other yield table functions: 
\code{\link{fe_yield_table}()},
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
