% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.psi}
\alias{plot.psi}
\title{Plot for "psi" type objects.}
\usage{
\method{plot}{psi}(x, ..., psi2 = NULL, gamma = 0.95, xlim = NULL, ylim = NULL, type = "psi")
}
\arguments{
\item{x}{A list containing the following information.
\describe{
  \item{[[1]]}{the membership function}
  \item{[[2]]}{the name of the sample distribution}
  \item{[[3]]}{sample size}
  \item{[[4]]}{the name of method}
  \item{[[5]]}{standard deviation (for the case of normal distribution).}
  \item{[[6]]}{the upper and lower bound function of the support of the membership function.}
}}

\item{...}{generic plot parameter.}

\item{psi2}{Another list containing the following information.
\describe{
 \item{[[1]]}{the membership function}
 \item{[[2]]}{the name of the sample distribution}
 \item{[[3]]}{sample size}
 \item{[[4]]}{the name of method}
 \item{[[5]]}{standard deviation (for the case of normal distribution).}
 \item{[[6]]}{the upper and lower bound function of the support of the membership function.}
}}

\item{gamma}{the confidence level.}

\item{xlim}{A vector containing the upper and lower values for the theta.}

\item{ylim}{A vector containing the values of omega to be included in the plot.}

\item{type}{The type of the plot, by default is the menbership function, and "length" for the expected length plot.}
}
\value{
No return value, called for side effects
}
\description{
Plot for "psi" type objects.
}
\examples{
x<-psi("GM",n=10)
plot(x)
plot(x,type="length")

x<-psi(0.5,n=10)
plot(x)
plot(x,type="length")
}
