% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title_options.R
\name{title_options}
\alias{title_options}
\title{Title output options.}
\usage{
title_options(
  title.main = NULL,
  title.ref = NULL,
  title.rowvar = NULL,
  title.colvar = NULL,
  title.unitvar = NULL,
  title.estvar = NULL,
  title.estvarn = NULL,
  title.filter = NULL,
  title.units = "acres",
  ...
)
}
\arguments{
\item{title.main}{String. TITLE, if savedata=TRUE and/or returntitle=TRUE:
the complete title used for table. If title.main=NULL, the title.*
parameters are used to generate title string. Note: if title.ref is not
NULL, it is added to title.main.}

\item{title.ref}{String. TITLE, if savedata=TRUE and/or returntitle=TRUE:
the ending text of the table title (e.g., Nevada, 2004-2005). If NULL, = "".}

\item{title.rowvar}{String. TITLE, if savedata=TRUE and/or returntitle=TRUE:
pretty name for the row domain variable. If NULL, = rowvar.}

\item{title.colvar}{String. TITLE, if savedata=TRUE and/or returntitle=TRUE:
pretty name for the column domain variable. If NULL, = colvar.}

\item{title.unitvar}{String. TITLE, if savedata=TRUE and/or
returntitle=TRUE: pretty name for the estimation unit variable. If NULL, =
unitvar.}

\item{title.estvar}{String. TITLE: if savedata=TRUE and/or returntitle=TRUE:
pretty name for the estimate variable. If NULL, title.estvar = estvar.name.}

\item{title.estvarn}{String. TITLE: if savedata=TRUE and/or returntitle=TRUE:
pretty name for the estimate variable. If NULL, title.estvar = estvar.name.}

\item{title.filter}{String. TITLE, if savedata=TRUE and/or returntitle=TRUE:
pretty name for filter(s). If title.filter=NULL, a default is generated from
cfilter.  If title.filter="", no title.filter is used.}

\item{title.units}{String.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for outputting
titles with custom aesthetics.
}
\description{
Returns a list of user-supplied parameters and parameter values for outputting
title with custom aesthetics.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

title_options(title.main = "My fancy title", title.estvar = "Estimate title")

}
\author{
Grayson W. White
}
\keyword{options}
