% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{logistic.loglik.ala}
\alias{logistic.loglik.ala}
\title{Log likelihood function for logistic regression with an approximate Laplace approximations used
This function is created as an example of how to create an estimator that is used
to calculate the marginal likelihood of a model.}
\usage{
logistic.loglik.ala(y, x, model, complex, mlpost_params = list(r = exp(-0.5)))
}
\arguments{
\item{y}{A vector containing the dependent variable}

\item{x}{The matrix containing the precalculated features}

\item{model}{The model to estimate as a logical vector}

\item{complex}{A list of complexity measures for the features}

\item{mlpost_params}{A list of parameters for the log likelihood, supplied by the user}
}
\value{
A list with the log marginal likelihood combined with the log prior (crit) and the posterior mode of the coefficients (coefs).
}
\description{
Log likelihood function for logistic regression with an approximate Laplace approximations used
This function is created as an example of how to create an estimator that is used
to calculate the marginal likelihood of a model.
}
\examples{
logistic.loglik.ala(as.integer(rnorm(100) > 0), matrix(rnorm(100)), TRUE, list(oc = 1))


}
