test_that("levels and counts are correct", {
  DF <- BuildCatDiffInput()
  indexA <- which(DF$auxVar == "Set1")
  sumFrame <- CompareCategoricalLevels(DF, "catVar", indexA)
  tbl <- table(DF$catVar)
  nCat <- length(tbl)
  expect_setequal(as.character(sumFrame$Level),
                  names(tbl))
  tbl0 <- table(DF$auxVar)
  expect_equal(sumFrame$nA, rep(as.numeric(tbl0)[1], nCat))
  expect_equal(sumFrame$nB, rep(as.numeric(tbl0)[2], nCat))
  tbl2 <- table(DF[indexA, "catVar"])
  expect_equal(sumFrame$xA, as.numeric(tbl2))
  tbl3 <- table(DF[-indexA, "catVar"])
  expect_equal(sumFrame$xB, as.numeric(tbl3))
})
test_that("statistics are correct",{
  DF <- BuildCatDiffInput()
  indexA <- which(DF$auxVar == "Set1")
  sumFrame <- CompareCategoricalLevels(DF, "catVar", indexA)
  n <- nrow(sumFrame)
  x1 <- sumFrame$xA
  n1 <- sumFrame$nA
  x2 <- sumFrame$xB
  n2 <- sumFrame$nB
  p1 <- (x1 + 1)/(n1 + 2)
  p2 <- (x2 + 1)/(n2 + 2)
  expect_equal(round(sumFrame$pA, digits = 5), round(p1, digits = 5))
  expect_equal(round(sumFrame$pB, digits = 5), round(p2, digits = 5))
  #
  loCI <- vector("numeric", n)
  upCI <- vector("numeric", n)
  signif <- vector("logical", n)
  cLevel <- 0.95
  for (i in 1:n){
    waldObj <- PropCIs::wald2ci(x1[i], n1[i], x2[i], n2[i], cLevel, adjust = "AC")
    ll <- waldObj$conf.int[1]
    uu <- waldObj$conf.int[2]
    loCI[i] <- ll
    upCI[i] <- uu
    if ((ll > 0) | (uu < 0)){
      signif[i] <- TRUE
    }
  }
  expect_equal(round(sumFrame$loCI, digits = 5), round(loCI, digits = 5))
  expect_equal(round(sumFrame$upCI, digits = 5), round(upCI, digits = 5))
  expect_equal(sumFrame$signif, signif)
})
test_that("object class is correct",{
  DF <- BuildCatDiffInput()
  indexA <- which(DF$auxVar == "Set1")
  sumFrame <- CompareCategoricalLevels(DF, "catVar", indexA)
  expect_s3_class(sumFrame, c("CatDiffs", "data.frame"))
})
