% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpochDownloader.r, R/EpochRepos.r
\name{EpochDownloader}
\alias{EpochDownloader}
\alias{names,EpochDownloader-method}
\alias{[,EpochDownloader-method}
\alias{$,EpochDownloader-method}
\alias{[[,EpochDownloader-method}
\alias{show,EpochDownloader-method}
\alias{length,EpochDownloader-method}
\alias{wiki}
\alias{wiki,EpochDownloader-method}
\alias{updateRepos}
\alias{EpochRepos}
\title{EpochDownloader constructor}
\usage{
EpochDownloader(id = NULL, progress = TRUE, verbose = FALSE, path = NULL)

\S4method{names}{EpochDownloader}(x)

\S4method{[}{EpochDownloader}(x, i)

\S4method{$}{EpochDownloader}(x, name)

\S4method{[[}{EpochDownloader}(x, i)

\S4method{show}{EpochDownloader}(object)

\S4method{length}{EpochDownloader}(x)

wiki(x, ...)

\S4method{wiki}{EpochDownloader}(x)

updateRepos(verbose = FALSE)

EpochRepos(verbose = TRUE)
}
\arguments{
\item{id}{Either the ID of an OSF project or the name of an iEEG projects (case insensitive). Check the available projects using \code{EpochRepos()}. The default points to the fragility data from the Fragility multi-center retrospective study.}

\item{progress}{Logical indicating whether to show progress during download.}

\item{verbose}{Logical indicating whether to show messages}

\item{path}{The path to the temporary folder where the files will be downloaded.}

\item{x}{An \code{EpochDownloader} object.}

\item{i}{Index or name of the files to be accessed.}

\item{name}{The name of the file to be accessed.}

\item{object}{An \code{EpochDownloader} object.}

\item{...}{Not used, for future extensibility}
}
\value{
\code{EpochDownloader}: An \code{EpochDownloader} object.

\code{names}: A character vector of file names.

\code{[}: A named list of \code{Epoch} objects. The names are the dataset names.

\code{$}: A single \code{Epoch} object.

\code{[[}: A single \code{Epoch} object.

\code{show}: Prints a summary of the \code{EpochDownloader} object.

\code{length}: Returns the number of files in the \code{EpochDownloader} object.

\code{wiki}: Opens the wiki page in the default browser

\code{updateRepos}: No return value, called for side effects.

\code{EpochRepos}: A list of project names and their corresponding OSF project IDs.
}
\description{
Manually update the project list from the remote repository.
This function will attempt to download the latest configuration
from the GitHub repository. If it fails, the current configuration
will remain unchanged.

This function returns the list of available projects.
If the configuration has not been fetched yet, it will
automatically update the project list from the remote repository.
}
\examples{
# list all available projects
EpochRepos()

# downloader for the fragility data
dl <- EpochDownloader(id = "fragility")

# list all Epoch objects in the downloader
names(dl)

# download the first Epoch object
\donttest{
 dl[1]
 # equivalent to (index by name)
 dl[names(dl)[1]]
}

# download the multiple Epoch objects
\donttest{
 dl[c(1, 2)]
 # equivalent to (index by name)
 dl[names(dl)[c(1, 2)]]
}

EpochRepos()
}
