% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{load_example_data}
\alias{load_example_data}
\title{Load Example Dataset}
\usage{
load_example_data(name)
}
\arguments{
\item{name}{Name of the dataset to load. Available datasets:
\itemize{
\item "logistic_growth" - Logistic population growth
\item "predator_prey" - Lotka-Volterra predator-prey dynamics
\item "interest_rate" - Vasicek mean-reverting interest rate
\item "epidemic_data" - SIR epidemic model
\item "oscillator_data" - Van der Pol oscillator
\item "business_cycle" - Kaldor-type business cycle
}}
}
\value{
A data.frame containing the time series data.
}
\description{
Load one of the example datasets included with the package.
}
\examples{
\donttest{
# Load logistic growth data if available
if(requireNamespace("utils", quietly = TRUE)) {
  try({
    data <- load_example_data("logistic_growth")
    head(data)
  })
}
}

}
