% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple-functions.R
\name{SimpleSim}
\alias{SimpleSim}
\title{Simple simulation function}
\usage{
SimpleSim(
  nreads = 1000,
  fn = 0.5,
  pnew = 0.05,
  pold = 0.001,
  rlen = 100,
  Ucont = 0.25
)
}
\arguments{
\item{nreads}{Number of reads to simulate}

\item{fn}{Fraction of reads that are new in simulation. Whether a read will
be new will be determined by a draw from a Bernoulli(fn) distribution.}

\item{pnew}{T-to-C mutation rate in new reads}

\item{pold}{T-to-C mutation rate in old reads}

\item{rlen}{Length of simulated reads}

\item{Ucont}{Fraction of nucleotides in simulated reads that are Ts (U in RNA)}
}
\value{
Tibble with 3 columns:
\itemize{
\item nT: Simulated number of Ts
\item TC: Simulated number of T-to-C mutations
\item n: Number of simulated reads with nT Ts and TC mutations.
}
}
\description{
Simple simulation function
}
\examples{

# Simulate 1 gene worth of data data
simdata <- SimpleSim()

}
