% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotIndication}
\alias{plotIndication}
\title{Generate a plot visualisation (ggplot2) from the output of
summariseIndication}
\usage{
plotIndication(
  result,
  x = "variable_level",
  position = "stack",
  facet = cdm_name + cohort_name ~ window_name,
  colour = "variable_level",
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Variable to plot on x-axis}

\item{position}{Position of bars, can be either \code{dodge} or \code{stack}}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character, this
may be either the name of a built-in style (see \code{plotStyle()}), or a path to
a \code{.yml} file that defines a custom style. If NULL, the function will use the
explicit default style, unless a global style option is set (see
\code{visOmopResults::setGlobalPlotOptions()}) or a \verb{_brand.yml} file is present
(in that order). Refer to the \strong{visOmopResults} package vignette on styles
to learn more.}
}
\value{
A ggplot2 object
}
\description{
Generate a plot visualisation (ggplot2) from the output of
summariseIndication
}
\examples{
\donttest{
library(DrugUtilisation)
library(CDMConnector)

cdm <- mockDrugUtilisation(source = "duckdb")

indications <- list(headache = 378253, asthma = 317009)
cdm <- generateConceptCohortSet(cdm = cdm,
                                conceptSet = indications,
                                name = "indication_cohorts")

cdm <- generateIngredientCohortSet(cdm = cdm,
                                   name = "drug_cohort",
                                   ingredient = "acetaminophen")

result <- cdm$drug_cohort |>
  summariseIndication(
    indicationCohortName = "indication_cohorts",
    unknownIndicationTable = "condition_occurrence",
    indicationWindow = list(c(-Inf, 0), c(-365, 0))
  )

plotIndication(result)

plotIndication(result, x = "window_name", facet = NULL)
}

}
