% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.emd.R
\name{as.emd}
\alias{as.emd}
\alias{is.emd}
\title{Create / Check emd objects}
\usage{
as.emd(
  xy,
  dt,
  imf,
  residue = NULL,
  ini = NULL,
  mode = NULL,
  repl = 1,
  order = NA
)

is.emd(emd)
}
\arguments{
\item{xy}{a vector of length n for the original signal at each dt}

\item{dt}{a vector of length n for the depth or time reference}

\item{imf}{a data.frame or matrix of n rows of the IMFs}

\item{residue}{a vector of length n for the residue of the decomposition}

\item{ini}{an optional vector of length n of the eventual initial Intrinsic
Mode Function xy would be a demodulation of, if it is a demodulation.}

\item{mode}{the mode sequence index to give to each replicated IMFs}

\item{repl}{the id of each replicates. The length of unique(repl) defines the
amount of replicates.}

\item{order}{the order of the imf, typically from higher frequency to lower
frequency}

\item{emd}{an emd object to check}
}
\value{
a list made of $xy (original signal), $dt (depth/time), $m (a matrix
of the decomposition), $repl (the replicate id of each point) and
$mode (the mode id of each point).
}
\description{
Allows to convert the result of a decomposition into a standard
list. The warnings of the is.emd checking function allow to identify the
problems.
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

s30  <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)
s240 <- 2 * sin(t*2*pi/p2)
sn   <- rnorm(n, sd = 0.5)

xy <- s30 + s240 + sn

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt  <- cumsum(inter_dt)

dec <- as.emd(xy = xy, dt = dt, imf = matrix(c(sn, s30, s240), ncol = 3))

plot_emd(dec, pdf = FALSE)

is.emd(dec)

\dontrun{
dec$xy <- 1
is.emd(dec)}

}
