% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed_functions.R
\name{rank_search_results}
\alias{rank_search_results}
\title{Rank Search Results}
\usage{
rank_search_results(data, terms_list, rank_method = "weighted")
}
\arguments{
\item{data}{A data frame containing search results.}

\item{terms_list}{A list of search terms.}

\item{rank_method}{The method to rank pubmed results, either "weighted" or "total". Weighted ranks results based on order of terms inputted. Total ranks results on total sum of publications across all search term combinations. Defaults to "weighted".}
}
\value{
A data frame with ranked search results, which includes the genes and their corresponding ranks based on the search method.
}
\description{
Rank search results based on a chosen method.
}
\examples{
# Example data frame
data <- data.frame(Gene = c("Gene1", "Gene2"),
                   Term1 = c(10, 20),
                   Term2 = c(5, 15))
terms_list <- c("Term1", "Term2")
ranked_results <- rank_search_results(data, terms_list, rank_method = "weighted")
print(ranked_results)
}
