% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb_functions.R
\name{plot_clustering}
\alias{plot_clustering}
\title{Plot STRING Interactions}
\usage{
plot_clustering(string_results, file_directory = NULL, export = FALSE)
}
\arguments{
\item{string_results}{Data frame with STRING metrics.}

\item{file_directory}{Directory for saving the output plot. Defaults to NULL.}

\item{export}{Logical indicating whether to export the plot. Defaults to FALSE.}
}
\value{
Invisibly returns the ggplot object.
}
\description{
Plot STRING interactions degree vs. clustering.
}
\examples{
# Example data frame
string_results <- data.frame(Degree = c(10, 5), Clustering_Coefficient_Percent = c(20, 10))
plot_clustering(string_results, file_directory = tempdir(), export = FALSE)
}
