% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calc_dte_assurance_adaptive}
\alias{calc_dte_assurance_adaptive}
\title{Calculates operating characteristics for a Group Sequential Trial with a Delayed Treatment Effect}
\usage{
calc_dte_assurance_adaptive(
  n_c,
  n_t,
  control_model,
  effect_model,
  recruitment_model,
  GSD_model,
  analysis_model = NULL,
  n_sims = 1000
)
}
\arguments{
\item{n_c}{Control group sample size}

\item{n_t}{Treatment group sample size}

\item{control_model}{A named list specifying the control arm survival distribution:
\itemize{
\item \code{dist}: Distribution type ("Exponential" or "Weibull")
\item \code{parameter_mode}: Either "Fixed" or "Distribution"
\item \code{fixed_type}: If "Fixed", specify as "Parameters" or "Landmark"
\item \code{lambda}, \code{gamma}: Scale and shape parameters
\item \code{t1}, \code{t2}: Landmark times
\item \code{surv_t1}, \code{surv_t2}: Survival probabilities at landmarks
\item \code{t1_Beta_a}, \code{t1_Beta_b}, \code{diff_Beta_a}, \code{diff_Beta_b}: Beta prior parameters
}}

\item{effect_model}{A named list specifying beliefs about the treatment effect:
\itemize{
\item \code{delay_SHELF}, \code{HR_SHELF}: SHELF objects encoding beliefs
\item \code{delay_dist}, \code{HR_dist}: Distribution types ("hist" by default)
\item \code{P_S}: Probability that survival curves separate
\item \code{P_DTE}: Probability of delayed separation, conditional on separation
}}

\item{recruitment_model}{A named list specifying the recruitment process:
\itemize{
\item \code{method}: "power" or "PWC"
\item \code{period}, \code{power}: Parameters for power model
\item \code{rate}, \code{duration}: Comma-separated strings for PWC model
}}

\item{GSD_model}{A named list specifying the group sequential design:
\itemize{
\item \code{events}: Total number of events
\item \code{alpha_spending}: Cumulative alpha spending vector
\item \code{alpha_IF}: Information Fraction at which we look for efficacy
\item \code{futility_type}: \code{beta} (for beta-spending), \code{BPP} (for Bayesian Predictive Probability) or \code{none}
\item \code{futility_IF}: Information Fraction at which we look for futility
\item \code{beta_spending}: Cumulative beta spending vector
\item \code{BPP_threshold}: BPP value at which we will stop for futility
}}

\item{analysis_model}{A named list specifying the final analysis and decision rule:
\itemize{
\item \code{method}: e.g. \code{"LRT"}, \code{"WLRT"}, or \code{"MW"}.
\item \code{alpha}: one-sided type I error level.
\item \code{alternative_hypothesis}: direction of the alternative (e.g. \code{"one.sided"}).
\item \code{rho}, \code{gamma}, \code{t_star}, \code{s_star}: additional parameters for WLRT or MW (if applicable).
}}

\item{n_sims}{Number of simulations to run (default = 1000)}
}
\value{
A data frame with one row per simulated trial and the following columns:
\describe{
\item{Trial}{Simulation index}
\item{IF}{Information fraction label used at the decision point}
\item{Decision}{Interim decision outcome (e.g., "Continue", "Stop for efficacy", "Stop for futility")}
\item{StopTime}{Time at which the trial stopped or completed}
\item{SampleSize}{Total sample size at the time of decision}
\item{Final_Decision}{Final classification of trial success based on the test statistic and threshold}
}
Class: \code{data.frame}
}
\description{
Simulates assurance and operating characteristics for a group sequential trial under prior uncertainty about a delayed treatment effect. The function integrates beliefs about control survival, treatment delay, post-delay hazard ratio, recruitment, and group sequential design (GSD) parameters.
}
\examples{
set.seed(123)
control_model <- list(dist = "Exponential", parameter_mode = "Fixed",
fixed_type = "Parameters", lambda = 0.1)
effect_model <- list(P_S = 1, P_DTE = 0,
HR_SHELF = SHELF::fitdist(c(0.6, 0.65, 0.7), probs = c(0.25, 0.5, 0.75), lower = 0, upper = 2),
HR_dist = "gamma",
delay_SHELF = SHELF::fitdist(c(3, 4, 5), probs = c(0.25, 0.5, 0.75), lower = 0, upper = 10),
delay_dist = "gamma"
)
recruitment_model <- list(method = "power", period = 12, power = 1)
GSD_model <- list(events = 300, alpha_spending = c(0.0125, 0.025),
                  alpha_IF = c(0.75, 1), futility_type = "none")
result <- calc_dte_assurance_adaptive(n_c = 300, n_t = 300,
                        control_model = control_model,
                        effect_model = effect_model,
                        recruitment_model = recruitment_model,
                        GSD_model = GSD_model,
                        n_sims = 10)
str(result)

}
