% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{MCD}
\alias{MCD}
\alias{MCD4010}
\title{Mean Catch Depletion}
\usage{
MCD(x, Data, reps = 100, plot = FALSE)

MCD4010(x, Data, reps = 100, plot = FALSE)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
A simple average catch-depletion MP that was included to demonstrate just
how informative an estimate of current stock depletion can be.
}
\details{
The TAC is calculated as:
\deqn{\textrm{TAC} = 2 \bar{C} D }
where \eqn{\bar{C}} is mean historical catch, and \eqn{D} is estimate of current
depletion.

The TAC is modified by a harvest control rule in \code{MCD4010}.
}
\section{Functions}{
\itemize{
\item \code{MCD()}: The calculated TAC = 2 \* depletion \* AvC

\item \code{MCD4010()}: Linked to a 40-10 harvest control rule

}}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{MCD}: Cat, Dep


\code{MCD4010}: Cat, Dep
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/MCD.html}{Online Documentation} for correctly rendered equations


}

\examples{
MCD(1, MSEtool::Atlantic_mackerel, plot=TRUE)
MCD4010(1, MSEtool::Atlantic_mackerel, plot=TRUE)
}
\author{
T. Carruthers
}
