% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataManagement.R
\name{createCyclopsData}
\alias{createCyclopsData}
\title{Create a Cyclops data object}
\usage{
createCyclopsData(
  formula,
  sparseFormula,
  indicatorFormula,
  modelType,
  data,
  subset = NULL,
  weights = NULL,
  censorWeights = NULL,
  offset = NULL,
  time = NULL,
  pid = NULL,
  y = NULL,
  type = NULL,
  dx = NULL,
  sx = NULL,
  ix = NULL,
  model = FALSE,
  normalize = NULL,
  floatingPoint = 64,
  method = "cyclops.fit"
)
}
\arguments{
\item{formula}{An object of class \code{"\link{formula}"} that provides a symbolic description of the numerically dense model response and terms.}

\item{sparseFormula}{An object of class \code{"\link{formula}"} that provides a symbolic description of numerically sparse model terms.}

\item{indicatorFormula}{An object of class \code{"\link{formula}"} that provides a symbolic description of \{0,1\} model terms.}

\item{modelType}{character string: Valid types are listed below.}

\item{data}{An optional data frame, list or environment containing the variables in the model.}

\item{subset}{Currently unused}

\item{weights}{Currently unused}

\item{censorWeights}{Vector of subject-specific censoring weights (between 0 and 1). Currently only supported in \code{modelType = "fgr"}.}

\item{offset}{Currently unused}

\item{time}{Currently undocumented}

\item{pid}{Optional vector of integer stratum identifiers. If supplied, all rows must be sorted by increasing identifiers}

\item{y}{Currently undocumented}

\item{type}{Currently undocumented}

\item{dx}{Optional dense \code{"\link[Matrix]{Matrix}"} of covariates}

\item{sx}{Optional sparse \code{"\link[Matrix]{Matrix}"} of covariates}

\item{ix}{Optional \{0,1\} \code{"\link[Matrix]{Matrix}"} of covariates}

\item{model}{Currently undocumented}

\item{normalize}{String: Name of normalization for all non-indicator covariates (possible values: stdev, max, median)}

\item{floatingPoint}{Integer: Floating-point representation size (32 or 64)}

\item{method}{Currently undocumented}
}
\value{
A list that contains a Cyclops model data object pointer and an operation duration
}
\description{
\code{createCyclopsData} creates a Cyclops data object from an R formula or data matrices.
}
\details{
This function creates a Cyclops model data object from R \code{"\link{formula}"} or directly from
numeric vectors and matrices to define the model response and covariates.
If specifying a model using a \code{"\link{formula}"}, then the left-hand side define the model response and the
right-hand side defines dense covariate terms.
Objects provided with \code{"sparseFormula"} and \code{"indicatorFormula"} must be include left-hand side responses and terms are
coersed into sparse and indicator representations for computational efficiency.

Items to discuss:
\itemize{
\item Only use formula or (y,dx,...)
\item stratum() in formula
\item offset() in formula
\item when \code{"stratum"} (renamed from pid) are necessary
\item when \code{"time"} are necessary
}
}
\section{Models}{

Currently supported model types are:
\tabular{ll}{
\verb{	"ls"} \tab Least squares \cr
\verb{	"pr"} \tab Poisson regression \cr
\verb{	"lr"} \tab Logistic regression \cr
\verb{	"clr"} \tab Conditional logistic regression \cr
\verb{	"cpr"} \tab Conditional Poisson regression \cr
\verb{	"sccs"} \tab Self-controlled case series \cr
\verb{	"cox"} \tab Cox proportional hazards regression \cr
\verb{	"fgr"} \tab Fine-Gray proportional subdistribution hazards regression \cr
}
}

\examples{
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
cyclopsData <- createCyclopsData(
     counts ~ outcome + treatment,
     modelType = "pr")
cyclopsFit <- fitCyclopsModel(cyclopsData)

cyclopsData2 <- createCyclopsData(
     counts ~ outcome,
     indicatorFormula = ~ treatment,
     modelType = "pr")
summary(cyclopsData2)
cyclopsFit2 <- fitCyclopsModel(cyclopsData2)

}
