% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMould_Zeng.R
\name{calcMould_Zeng}
\alias{calcMould_Zeng}
\title{Calculate Mould Growth Rate Limits (Zeng et al.)}
\usage{
calcMould_Zeng(Temp, RH, LIM = 0, label = FALSE)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{LIM}{The specific LIM value to calculate. Must be one of
0, 0.1, 0.5, 1, 2, 3, or 4. Default is 0.}

\item{label}{Logical. If TRUE, returns a descriptive label instead of a numeric value.
Default is FALSE.}
}
\value{
If label is FALSE, returns the calculated LIM value as Relative Humidity (0-100\%).
        If label is TRUE, returns a character string describing the mould growth rate category.
}
\description{
This function calculates the Lowest Isoline for Mould (LIM) based on temperature
and relative humidity, using the model developed by Zeng et al. (2023).

The LIM is the lowest envelope of the temperature and humidity isoline at a certain
mould growth rate (u). LIM0 is the critical value for mould growth, if the humidity
is kept below the critcal value, at a given temperature, then there is no risk of mould growth.
}
\details{
The function calculates LIM values for mould genera including Cladosporium, Penicillium, and Aspergillus.
LIM values represent different mould growth rates:

\itemize{
  \item LIM0: Low limit of mould growth
  \item LIM0.1: 0.1 mm/day growth rate
  \item LIM0.5: 0.5 mm/day growth rate
  \item LIM1: 1 mm/day growth rate
  \item LIM2: 2 mm/day growth rate
  \item LIM3: 3 mm/day growth rate
  \item LIM4: 4 mm/day growth rate
  \item Above LIM4: Greater than 4 mm/day growth rate (9 mm/day theorectical maximum)
}
}
\examples{
# Lowest Isoline for Mould at 20°C (Temp) and 75\% relative humidity (RH)
calcMould_Zeng(20, 75)
calcMould_Zeng(20, 75, LIM = 0)
calcMould_Zeng(20, 75, label = TRUE)

calcMould_Zeng(20, 85)
calcMould_Zeng(20, 85, LIM = 2)
calcMould_Zeng(20, 85, label = TRUE)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |>
   dplyr::mutate(
      RH_LIM0 = calcMould_Zeng(Temp, RH),
      RH_LIM1 = calcMould_Zeng(Temp, RH, LIM = 1),
      LIM = calcMould_Zeng(Temp, RH, label = TRUE)
   )


}
\references{
Zeng L, Chen Y, Ma M, et al. Prediction of mould growth rate within building envelopes:
development and validation of an improved model.
Building Services Engineering Research and Technology. 2023;44(1):63-79.
doi:10.1177/01436244221137846

Sautour M, Dantigny P, Divies C, Bensoussan M. A temperature-type model for
describing the relationship between fungal growth and water activity.
Int J Food Microbiol. 2001 Jul 20;67(1-2):63-9.
doi: 10.1016/s0168-1605(01)00471-8. PMID: 11482570.
}
