% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetOnDoseForm.R
\name{subsetOnDoseForm}
\alias{subsetOnDoseForm}
\title{Subset a codelist to only those codes from a particular domain.}
\usage{
subsetOnDoseForm(x, cdm, doseForm, negate = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{doseForm}{Dose form/s. See \code{availableDoseForms()} to explore available dose forms
in your codelist.}

\item{negate}{If FALSE, only concepts with the dose form specified will be
returned. If TRUE, concepts with the dose form specified will be excluded.}
}
\value{
The codelist with only those concepts associated with the dose form
(if negate = FALSE) or the codelist without those concepts associated with
the dose form (if negate = TRUE).
}
\description{
Subset a codelist to only those codes from a particular domain.
}
\examples{
\donttest{
library(CodelistGenerator)
library(omopgenerics)
cdm <- mockVocabRef()

codelist <- newCodelist(list("codes" = c(10L,20L,21L)))

# Dose forms present in our codelist:
codelist |> associatedDoseForms(cdm)

codes <- subsetOnDoseForm(
              x = codelist,
              cdm = cdm,
              doseForm = "Injection")
codes

codes |> associatedDoseForms(cdm)
}

}
