% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableVocabularies.R
\name{availableVocabularies}
\alias{availableVocabularies}
\title{Get the available vocabularies available in the cdm}
\usage{
availableVocabularies(cdm, standardConcept = "Standard", domain = NULL)
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{domain}{Character vector with one or more of the OMOP CDM domains.
The results will be restricted to the given domains. Check the available
ones by running availableDomains(). If NULL, all supported domains are included:
Condition, Drug, Procedure, Device, Observation, and Measurement.}
}
\value{
Names of available vocabularies.
}
\description{
Get the available vocabularies available in the cdm
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all vocabularies available in the CDM
availableVocabularies(cdm)

# Get all vocabularies available in the CDM for `Standard` and `Condition` concepts
availableVocabularies(cdm,
                      standardConcept = "Standard",
                      domain = "Condition")
}
}
