% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateMDLfrom_dmptxt.R
\name{UpdateMDLfrom_dmptxt}
\alias{UpdateMDLfrom_dmptxt}
\title{Update Model text file from NLME output File}
\usage{
UpdateMDLfrom_dmptxt(
  dmpfile = "dmp.txt",
  SharedWorkingDir = getwd(),
  model_file = "test.mdl",
  compile = TRUE,
  output_file = "test.mdx"
)
}
\arguments{
\item{dmpfile}{The path to the DMP text file.}

\item{SharedWorkingDir}{The working directory. Used if \code{dmpfile},
\code{model_file}, \code{output_file} are given without path.}

\item{model_file}{The name of the model file to be updated (with optional
full path).}

\item{compile}{A logical value indicating whether to compile the updated
model file into NLME executable. Default is \code{TRUE}, it also overwrites
\code{model_file} with updated estimates (i.e. making the same as
\code{output_file}.)}

\item{output_file}{The name of the new model file with updated estimates.}
}
\value{
The path to the updated model file.
}
\description{
This function updates a model file with parameter estimates obtained from a
dmp file (R structure format of output generated by NLME) text file. The
updated model file includes the estimated fixed effects, error terms and
random effects values.
}
\details{
\code{TDL5} executable from NLME Engine is used. NLME engine
location is identified by \code{INSTALLDIR} environment variable. The current
function will give an error if \code{TDL5} cannot be executed.
}
