% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-wfs.R
\encoding{UTF-8}
\name{inspire_wfs_get}
\alias{inspire_wfs_get}
\title{Client tool for WFS INSPIRE services}
\usage{
inspire_wfs_get(
  scheme = "https",
  hostname = "ovc.catastro.meh.es",
  path = "INSPIRE/wfsCP.aspx",
  query = list(),
  verbose = FALSE
)
}
\arguments{
\item{scheme}{Identifies the protocol to be used to access the resource on
the Internet.}

\item{hostname}{Identifies the host that holds the resource.}

\item{path}{Identifies the specific resource in the host that the web client
wants to access.}

\item{query}{A named list with the name and value of the arguments to query.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A character string with the path of the resulting file in the \code{\link[=tempfile]{tempfile()}}
folder.
}
\description{
Client tool for WFS INSPIRE services
}
\details{
This function is used internally in all the WFS calls. We expose it to make
it available to other users and/or developers for accessing other
cadastral or INSPIRE resources. See \strong{Examples}.
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
# Accessing the Cadastre of Navarra
# Try also https://ropenspain.github.io/CatastRoNav/

file_local <- inspire_wfs_get(
  hostname = "inspire.navarra.es",
  path = "services/BU/wfs",
  query = list(
    service = "WFS",
    request = "getfeature",
    typenames = "BU:Building",
    bbox = "609800,4740100,611000,4741300",
    SRSNAME = "EPSG:25830"
  )
)

if (!is.null(file_local)) {
  pamp <- sf::read_sf(file_local)

  library(ggplot2)
  ggplot(pamp) +
    geom_sf()
}
\dontshow{\}) # examplesIf}
}
\seealso{
INSPIRE API functions:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}

Other INSPIRE WFS services:
\code{\link{catr_srs_values}},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()}
}
\concept{INSPIRE}
\concept{WFS}
