% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{radial_ivus_df}
\alias{radial_ivus_df}
\title{Radial Artery IVUS Patient Data}
\format{
A data frame with 115 observations and 15 variables:
\describe{
\item{male}{Male sex indicator (integer: 0/1)}
\item{age}{Age in years (integer)}
\item{height}{Height in cm (numeric)}
\item{weight}{Weight in kg (numeric)}
\item{HBP}{High blood pressure status (integer: 0/1)}
\item{DM}{Diabetes mellitus status (integer: 0/1)}
\item{smoking}{Smoking status (factor with 3 levels)}
\item{TC}{Total cholesterol in mg/dL (integer)}
\item{TG}{Triglycerides in mg/dL (integer)}
\item{HDL}{HDL cholesterol in mg/dL (integer)}
\item{LDL}{LDL cholesterol in mg/dL (integer)}
\item{hsCRP}{High-sensitivity C-reactive protein in mg/L (numeric)}
\item{NTAV}{Normalized total atheroma volume (numeric)}
\item{PAV}{Percent atheroma volume (numeric)}
\item{sex}{Sex (factor with 2 levels)}
}
}
\source{
Data taken from the moonBook package version 0.3.1
}
\usage{
data(radial_ivus_df)
}
\description{
This dataset, radial_ivus_df, is a data frame containing demographic and clinical
data from 115 patients who underwent intravascular ultrasound (IVUS) examination
of the radial artery following transradial coronary angiography. It includes 15
variables covering patient characteristics, laboratory results, and IVUS measurements.
}
\details{
The dataset name has been kept as 'radial_ivus_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
