
<!-- README.md is generated from README.Rmd. Please edit that file -->

# CGMissingDataR

<!-- badges: start -->

[![R-CMD-check](https://github.com/saraswatsh/CGMissingDataR/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/saraswatsh/CGMissingDataR/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

CGMissingDataR is an R package based on the CGMissingData Python library
for evaluating model performance under feature missingness by:

- injecting missing values into feature columns at specified masking
  rates,
- imputing missing values using a Multiple Imputation by Chained
  Equations (MICE)-style iterative imputer, and
- training Random Forest and k-Nearest Neighbors regressors to report
  Mean ABsolute Percentage Error (MAPE) and R across missingness levels.

Before the installation, ensure that you have the following R packages
installed:

``` r
install.packages(c("FNN", "ranger", "mice"))
```

Install the development version of CGMissingDataR from GitHub:

``` r
devtools::install_github("saraswatsh/CGMissingDataR")
```

## Vignette

A brief vignette illustrating the usage of CGMissingDataR can be found
[here](https://saraswatsh.github.io/CGMissingDataR/articles/How-To-Use-CGMissingDataR.html).

## Changelog

The changelog is available
[here](https://saraswatsh.github.io/CGMissingDataR/news/index.html).
