% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rotate_obj.R
\name{Rotate_obj}
\alias{Rotate_obj}
\title{Rotate object}
\usage{
Rotate_obj(Input, Lon0 = NULL)
}
\arguments{
\item{Input}{Spatial object of class \code{sf}, \code{sfc} or \code{SpatRaster (terra)}.}

\item{Lon0}{numeric, longitude that will point up in the resulting map.}
}
\value{
Spatial object in your environment to only be used for plotting, not for analysis.
}
\description{
Rotate a spatial object by setting the longitude that should point up.
}
\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#47-rotate_obj
# and:
# https://github.com/ccamlr/CCAMLRGIS/blob/master/Basemaps/Basemaps.md

RotB=Rotate_obj(SmallBathy(),Lon0=-180)
terra::plot(RotB,breaks=Depth_cuts,col=Depth_cols,axes=FALSE,box=FALSE,legend=FALSE)
add_RefGrid(bb=st_bbox(RotB),ResLat=10,ResLon=20,LabLon = -180,offset = 3)

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Lines}}, \code{\link{create_Polys}},
\code{\link{create_PolyGrids}}, \code{\link{create_Stations}}, \code{\link{create_Pies}},
\code{\link{create_Arrow}}.
}
