% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastBarPrior.R
\name{createFastBarPrior}
\alias{createFastBarPrior}
\title{Create a fastBAR Cyclops prior object}
\usage{
createFastBarPrior(
  penalty = 0,
  exclude = c(),
  forceIntercept = FALSE,
  fitBestSubset = FALSE,
  initialRidgeVariance = 10000,
  tolerance = 1e-08,
  maxIterations = 10000,
  threshold = 1e-06
)
}
\arguments{
\item{penalty}{Specifies the BAR penalty}

\item{exclude}{A vector of numbers or covariateId names to exclude from prior}

\item{forceIntercept}{Logical: Force intercept coefficient into regularization}

\item{fitBestSubset}{Logical: Fit final subset with no regularization}

\item{initialRidgeVariance}{Numeric: variance used for algorithm initiation}

\item{tolerance}{Numeric: maximum abs change in coefficient estimates from successive iterations to achieve convergence}

\item{maxIterations}{Numeric: maximum iterations to achieve convergence}

\item{threshold}{Numeric: absolute threshold at which to force coefficient to 0}
}
\value{
A BAR Cyclops prior object of class inheriting from
\code{"cyclopsPrior"} for use with \code{fitCyclopsModel}.
}
\description{
\code{createFastBarPrior} creates a fastBAR Cyclops prior object for use with \code{\link[Cyclops]{fitCyclopsModel}}.
}
\examples{
nobs = 500; ncovs = 100
prior <- createFastBarPrior(penalty = log(ncovs), initialRidgeVariance = 1 / log(ncovs))

}
