% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCreate_hdf5_matrix}
\alias{bdCreate_hdf5_matrix}
\title{Create hdf5 data file and write data to it}
\usage{
bdCreate_hdf5_matrix(
  filename,
  object,
  group = NULL,
  dataset = NULL,
  transp = NULL,
  overwriteFile = NULL,
  overwriteDataset = NULL,
  unlimited = NULL
)
}
\arguments{
\item{filename, }{character array indicating the name of the file to create}

\item{object}{numerical data matrix}

\item{group, }{character array indicating folder name to put the matrix in hdf5 file}

\item{dataset, }{character array indicating the dataset name to store the matrix data}

\item{transp}{boolean, if trans=true matrix is stored transposed in hdf5 file}

\item{overwriteFile, }{optional boolean by default overwriteFile = false, if
true and file exists, removes old file and creates a new file with de dataset
data.}

\item{overwriteDataset, }{optional boolean by default overwriteDataset = false,
if true and dataset exists, removes old dataset and creates a new dataset.}

\item{unlimited, }{optional boolean by default unlimited = false, if true
creates a dataset that can growth.}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the created matrix (group/dataset)}
}
}
\description{
Creates a hdf5 file with numerical data matrix,
}
\examples{

matA <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15), nrow = 3, byrow = TRUE)
bdCreate_hdf5_matrix(filename = "test_temp.hdf5", 
                    object = matA, group = "datasets", 
                    dataset = "datasetA", transp = FALSE, 
                    overwriteFile = TRUE, 
                    overwriteDataset = TRUE,
                    unlimited = FALSE)

# Remove file (used as example)
  if (file.exists("test_temp.hdf5")) {
    # Delete file if it exist
    file.remove("test_temp.hdf5")
  }

}
