% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.BayesMallowsSMC2}
\alias{print.BayesMallowsSMC2}
\title{Print Method for BayesMallowsSMC2 Objects}
\usage{
\method{print}{BayesMallowsSMC2}(x, ...)
}
\arguments{
\item{x}{An object of class \code{BayesMallowsSMC2}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Prints a summary of a BayesMallowsSMC2 object returned by
\code{\link[=compute_sequentially]{compute_sequentially()}}.
}
\details{
The print method displays key information about the fitted Bayesian Mallows
model, including:
\itemize{
\item Number of particles
\item Number of timepoints
\item Number of items
\item Number of clusters
\item Log marginal likelihood
\item Final effective sample size (ESS)
\item Number of resampling events
}
}
\examples{
# Fit a model with complete rankings
set.seed(123)
mod <- compute_sequentially(
  complete_rankings,
  hyperparameters = set_hyperparameters(n_items = 5),
  smc_options = set_smc_options(n_particles = 100, n_particle_filters = 1)
)

# Print the model
print(mod)

# or simply
mod

}
