% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineProblem.R
\name{DefineProblem}
\alias{DefineProblem}
\title{Define the speciation problem}
\usage{
DefineProblem(ParamFile, WriteLog = FALSE)
}
\arguments{
\item{ParamFile}{the path and file name to a parameter file}

\item{WriteLog}{if TRUE, the CHESS.LOG file will be written, summarizing the
current problem}
}
\value{
Returns a `list` object with each list item named according to the
  template of BlankProblem
}
\description{
`DefineProblem` reads in a parameter file, and sets up the required vectors
and matrices that will be needed to run the speciation calculations in CHESS.
}
\examples{
mypfile = system.file("extdata", "ParameterFiles",
                      "carbonate_system_only.dat4",
                      package = "BLMEngineInR", mustWork = TRUE)
thisProblem = DefineProblem(mypfile)

}
