% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfs_get_sse_data.R
\name{bfs_get_sse_data}
\alias{bfs_get_sse_data}
\title{Get Data from Swiss Stats Explorer (SSE) API}
\usage{
bfs_get_sse_data(
  number_bfs,
  language = "de",
  start_period = NULL,
  end_period = NULL,
  query = NULL,
  column_name_type = "code",
  variable_value_type = "text",
  clean_names = FALSE
)
}
\arguments{
\item{number_bfs}{The BFS number (FSO number) of a dataset.}

\item{language}{Language of the dataset to be translated if exists, i.e. "de", "fr", "it" or "en".}

\item{start_period}{Start year of the requested data}

\item{end_period}{End year of the requested data}

\item{query}{A named list with dimension codes as names and desired values as values.}

\item{column_name_type}{Column name type as "text" or as "code".}

\item{variable_value_type}{Variable value type as "text" or as "code".}

\item{clean_names}{Logical, if TRUE, the column names are cleaned using janitor::clean_names().}
}
\value{
A tibble with the requested data.
}
\description{
Get Data from Swiss Stats Explorer (SSE) API
}
\examples{
bfs_get_sse_data(
  number_bfs = "DF_PASTA_552_MONTHLY", 
  language = "en", 
  query =  list("FREQ" = "M", "ACCOMMODATION_TYPE" = c("552001"), 
                "COUNTRY_ORIGIN" = c("CH", "AUSL")),
  start_period = "2020",
  end_period = "2023"
  )
}
