% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ft_fouls.R
\name{do_ft_fouls}
\alias{do_ft_fouls}
\title{Compute free throw fouls}
\usage{
do_ft_fouls(data, type)
}
\arguments{
\item{data}{Play-by-play data.}

\item{type}{Either 'comm' (for committed) or 'rec' (for received).}
}
\value{
Data frame with the following columns:
\itemize{
  \strong{team}: Name of the team.
  \strong{player}: Name of the player.
  \strong{n_ft_fouls_x}: Number of free throw fouls committed or received.
  \strong{n_ft_x}: Number of free throws given or got.
  \strong{n_ft_char}: Type of free throw. Options can be 1TL, 2TL and 3TL.
  \strong{n}: Number of free throws of each type.
}
}
\description{
Compute how many 1-,2- and 3-free throw fouls has committed or 
received every player.
}
\examples{
df01 <- do_ft_fouls(acb_vbc_cz_pbp_2223, "comm")
#df01  
 
df02 <- do_ft_fouls(acb_vbc_cz_pbp_2223, "rec")
#df02

}
\author{
Guillermo Vinue
}
