% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_best_zones.R
\name{do_best_zones}
\alias{do_best_zones}
\title{Best players by zone}
\usage{
do_best_zones(data_best_archetypoid)
}
\arguments{
\item{data_best_archetypoid}{Best players by zone computed with the
archetypoid algorithm.}
}
\value{
A plot.
}
\description{
Creates a visualization of the players who shoot little and score a lot 
in several zones at the same time.
}
\examples{
\dontrun{
library(dplyr)
library(Anthropometry)

zones_court <- metrics_player_zone \%>\% 
  distinct(location) \%>\%
  pull()

numArch <- 10 
numRep <- 20
numArchoid <- 2 # Number of archetypoids.

data_arch <- data.frame()

# Run the algorithm for each zone one by one and save the archetypoid 
# with least shots and highest percentage.
i <- 1

zone <- metrics_player_zone \%>\% 
  filter(location == zones_court[i]) \%>\% 
  select(-pps_player)

zone_num <- zone \%>\% 
  select(total, perc_player) 

lass <- stepArchetypesRawData(data = zone_num, numArch = 1:numArch, 
                              numRep = numRep, verbose = FALSE)  

res_ns <- archetypoids(numArchoid, zone_num, huge = 200, step = FALSE, 
                       ArchObj = lass, nearest = "cand_ns",sequ = TRUE)
zone[res_ns$cases, ]                        

# Here [1, ] indicates the archetypoid of interest. Change it accordingly.
# Here 4 indicates the number of similar players to the archetypoid. Change it accordingly.
arch_targ <- zone[order(res_ns$alphas[1, ], decreasing = TRUE)[1:4], ]
data_arch <- rbind(data_arch, arch_targ)

i <- 2

zone <- metrics_player_zone \%>\% 
  filter(location == zones_court[i]) \%>\% 
  select(-pps_player)

zone_num <- zone \%>\% 
  select(total, perc_player) 

lass <- stepArchetypesRawData(data = zone_num, numArch = 1:numArch, 
                              numRep = numRep, verbose = FALSE)  

res_ns <- archetypoids(numArchoid, zone_num, huge = 200, step = FALSE, 
                       ArchObj = lass, nearest = "cand_ns",sequ = TRUE)

arch_targ <- zone[order(res_ns$alphas[2, ], decreasing = TRUE)[1:10], ]
data_arch <- rbind(data_arch, arch_targ)

do_best_zones(data_arch)
}

}
\seealso{
\link[Anthropometry]{archetypoids}
}
\author{
Guillermo Vinue
}
