% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hull.beta}
\alias{hull.beta}
\title{Beta diversity partitioning using convex hull hypervolumes.}
\usage{
hull.beta(comm, func = "jaccard", comp = FALSE)
}
\arguments{
\item{comm}{A list of 'convhulln' objects, preferably built with function hull.build.}

\item{func}{Partial match indicating whether the Jaccard (default) or Soerensen family of beta diversity measures should be used.}

\item{comp}{Boolean indicating whether beta diversity components (shared and unique fractions) should be returned.}
}
\value{
Five pairwise distance matrices, one per each of the five beta diversity metrics.  If comp = TRUE also three distance matrices with beta diversity components.
}
\description{
Pairwise beta diversity partitioning into replacement and net difference in amplitude components of convex hulls.
}
\details{
Computes a pairwise decomposition of the overall differentiation among convex hull hypervolumes.
The beta diversity measures used here follow the partitioning frameworks developed by Podani & Schmera (2011), Carvalho et al. (2012) and Legendre (2019)
and later expanded to PD and FD by Cardoso et al. (2014), where Btotal = Brepl + Brich or Btotal = Bgain + Bloss.
Btotal = total beta diversity, reflecting both species replacement and loss/gain;
Brepl = beta diversity explained by replacement of species alone; Brich = beta diversity explained by species loss/gain (richness differences) alone;
Bgain = beta diversity explained by species gain from T1 to T2; Bloss = beta diversity explained by species lost from T1 to T2.
}
\examples{
comm <- rbind(c(1,1,1,1,1), c(1,1,1,1,1), c(0,0,1,1,1),c(0,0,1,1,1))
colnames(comm) = c("SpA","SpB","SpC","SpD", "SpE")
rownames(comm) = c("Site 1","Site 2","Site 3","Site 4")

trait <- cbind(c(2.2,4.4,6.1,8.3,3),c(0.5,1,0.5,0.4,4))
colnames(trait) = c("Trait 1","Trait 2")
rownames(trait) = colnames(comm)

hvlist = hull.build(comm, trait)
hull.beta(hvlist)
hull.beta(hvlist, comp = TRUE)
}
\references{
Cardoso, P., Rigal, F., Carvalho, J.C., Fortelius, M., Borges, P.A.V., Podani, J. & Schmera, D. (2014) Partitioning taxon, phylogenetic and functional beta diversity into replacement and richness difference components. Journal of Biogeography, 41, 749-761.

Carvalho, J.C., Cardoso, P. & Gomes, P. (2012) Determining the relative roles of species replacement and species richness differences in generating beta-diversity patterns. Global Ecology and Biogeography, 21, 760-771.

Legendre, P. (2019) A temporal beta-diversity index to identify sites that have changed in exceptional ways in space–time surveys. Ecology and Evolution, 9: 3500-3514.

Podani, J. & Schmera, D. (2011) A new conceptual and methodological framework for exploring and explaining pattern in presence-absence data. Oikos, 120, 1625-1638.
}
