% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binner.R
\name{uniBinner}
\alias{uniBinner}
\title{Single margin binning}
\usage{
uniBinner(x, y, stopper, splitter, dropPoints = FALSE, on = "y")
}
\arguments{
\item{x}{factor vector for the the first variable}

\item{y}{numeric vector of the second variable (to be split)}

\item{stopper}{function which accepts a list with elements
`x`, `y`, `bnds`, `expn`, and `n` and returns a logical indicating
whether a split should occur for the bin defined by that list}

\item{splitter}{function which accepts a list of lists with
elements `x`, `y`, `bnds`, `expn`, and `n` and returns a list
where each element is a list of two corresponding to a split of
the bin at that position in the original list}

\item{dropPoints}{logical; should points be dropped from final
bins?}

\item{on}{one of 'x' or 'y': the margin to split}
}
\value{
A list of lists each with elements `x`, `y`, `bnds`,
`expn`, `n`, and `stopped`.
}
\description{
`uniBinner` is an iterative implementation of a
recursive binary partitioning algorithm which accepts the
splitting and stopping functions that guide partitioning as
arguments and applies them to a specified margin alone.
}
\details{
`binner` creates a one-dimensional histogram of `y` or
`x` for each categorical value of the other by recursively
splitting partitions of the data using `splitter` until
`stopper` indicates that all partitions are not to be split.
}
\author{
Chris Salahub
}
