% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePops.R
\name{mergePops}
\alias{mergePops}
\title{Merge list of populations}
\usage{
mergePops(popList)
}
\arguments{
\item{popList}{a list containing \code{\link{Pop-class}} elements
or a \code{\link{MultiPop-class}}}
}
\value{
Returns a \code{\link{Pop-class}}
}
\description{
Rapidly merges a list of populations into a
single population
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}

#Create a list of populations and merge list
pop = newPop(founderPop, simParam=SP)
pop@misc$tmp = rnorm(n=10)
pop@misc$tmp2 = rnorm(n=10)

popList = list(pop, pop)
pop2 = mergePops(popList)

}
