/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.util.ResourceFactory;
import lombok.Generated;
import lombok.NonNull;

public final class ResourcePool<RESOURCE extends Closeable> {
    @Generated
    private static final Logger log = Logger.getLogger(ResourcePool.class.getName());
    @NonNull
    private final Wrapper<RESOURCE> wrapper;
    @NonNull
    private final ConcurrentMap<DataSource, RESOURCE> resources;
    @NonNull
    private final Consumer<IOException> onCloseError;

    @NonNull
    public static <T extends Closeable> ResourcePool<T> of(Wrapper<T> wrapper) {
        return new ResourcePool<T>(wrapper, new ConcurrentHashMap(), ResourcePool::log);
    }

    @NonNull
    public RESOURCE get(@NonNull DataSource dataSource, @NonNull ResourceFactory<RESOURCE> delegate) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        Closeable result = (Closeable)this.resources.remove(dataSource);
        if (result == null) {
            result = delegate.open(dataSource);
        }
        Closeable finalResult = result;
        return (RESOURCE)this.wrapper.wrap(finalResult, () -> this.recycle(dataSource, finalResult));
    }

    public void remove(DataSource dataSource) {
        Closeable connection = (Closeable)this.resources.remove(dataSource);
        if (connection != null) {
            this.closeSilently(connection);
        }
    }

    public void clear() {
        this.resources.values().forEach(this::closeSilently);
        this.resources.clear();
    }

    @NonNull
    public ResourceFactory<RESOURCE> asFactory(@NonNull ResourceFactory<RESOURCE> delegate) {
        Objects.requireNonNull(delegate);
        return dataSource -> this.get(dataSource, delegate);
    }

    private void recycle(DataSource dataSource, RESOURCE resource) throws IOException {
        if (this.resources.putIfAbsent(dataSource, resource) != null) {
            resource.close();
        }
    }

    private void closeSilently(RESOURCE resource) {
        try {
            resource.close();
        }
        catch (IOException ex) {
            this.onCloseError.accept(ex);
        }
    }

    private static void log(IOException ex) {
        log.log(Level.SEVERE, null, ex);
    }

    @Generated
    public ResourcePool(@NonNull Wrapper<RESOURCE> wrapper, @NonNull ConcurrentMap<DataSource, RESOURCE> resources, @NonNull Consumer<IOException> onCloseError) {
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        if (resources == null) {
            throw new NullPointerException("resources is marked non-null but is null");
        }
        if (onCloseError == null) {
            throw new NullPointerException("onCloseError is marked non-null but is null");
        }
        this.wrapper = wrapper;
        this.resources = resources;
        this.onCloseError = onCloseError;
    }

    @FunctionalInterface
    public static interface Wrapper<T extends Closeable> {
        @NonNull
        public T wrap(@NonNull T var1, @NonNull Closeable var2);
    }
}

